# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 1
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR1_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR1(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:  # Round 1
        return "C"
    
    # Analyze opponent's code for known strategies
    always_defect = "return 'D'" in opponent_program_code or "always defect" in opponent_program_code.lower()
    tit_for_tat = "opp_history[-1]" in opponent_program_code or "my_history[-1]" in opponent_program_code
    mostly_cooperative = "return 'C'" in opponent_program_code or "always cooperate" in opponent_program_code.lower()
    
    if always_defect:
        return "D"
    elif mostly_cooperative:
        return "C"
    elif tit_for_tat:
        return opp_history[-1] if opp_history else "C"
    
    # Fallback to history-based adaptation
    if opp_history:
        if opp_history.count("D") >= 2:  # Multiple defections
            return "D"
        elif opp_history[-1] == "D":  # Tit-for-Tat response
            return "D"
        else:
            # Forgive if opponent cooperates after defection
            if len(opp_history) >= 2 and opp_history[-2] == "D" and opp_history[-1] == "C":
                return "C"
            # Final rounds: defect if opponent has been exploitative
            if len(my_history) >= 8 and "D" in opp_history:
                return "D"
            return "C"
    
    return "D"  # Default fallback